---
title: "Troubleshooting"
description: "Fix common issues"
---

# Troubleshooting Guide

Solutions to common issues with PWA Plus installation, configuration, and usage.

---

## Installation Issues

### Module Not Appearing in Addon Modules

**Problem:** PWA Plus doesn't show up in Setup > Addon Modules.

**Solutions:**
1. **Verify file location** - Module must be in `/modules/addons/pwaplus/`
2. **Check file permissions**:
   ```bash
   chmod 755 /path/to/whmcs/modules/addons/pwaplus
   chmod 644 /path/to/whmcs/modules/addons/pwaplus/*.php
   ```
3. **Clear WHMCS cache** - Delete `/templates_c/` contents
4. **Check PHP version** - Must be PHP 7.4 or 8.x
5. **Review error logs** - Check WHMCS activity log for errors

### Cannot Activate Module

**Problem:** Activation fails or shows an error.

**Solutions:**
1. **Verify PHP requirements** - Check PHP version compatibility
2. **Check database permissions** - Ensure WHMCS can create tables
3. **Review WHMCS logs** - Look for specific error messages
4. **Verify WHMCS version** - Must be 8.0 or later
5. **Check file integrity** - Re-upload module files

### Upload Errors

**Problem:** Cannot upload module files to server.

**Solutions:**
1. **Check disk space** - Ensure sufficient server storage
2. **Verify FTP permissions** - Confirm write access
3. **Use correct upload method** - Binary mode for FTP
4. **Check file size limits** - Increase if necessary
5. **Extract locally first** - Upload extracted folder, not ZIP

---

## PWA Installation Issues

### "Install App" Button Not Appearing

**Problem:** Users don't see the option to install the PWA.

**Solutions:**
1. **Verify HTTPS** - PWA requires valid SSL certificate
   - Check for padlock icon in browser
   - No mixed content warnings
   - Certificate not expired
2. **Check browser compatibility**:
   - Chrome (Desktop & Android)
   - Edge (Desktop)
   - Safari (iOS/Mac) - uses "Add to Home Screen"
   - Firefox (limited PWA support)
3. **Clear browser cache** - Hard refresh (Ctrl+Shift+R / Cmd+Shift+R)
4. **Verify manifest.json** - Check it's accessible at `/manifest.json`
5. **Check service worker** - Open DevTools > Application > Service Workers

### PWA Doesn't Install on iOS

**Problem:** Installation not working on iPhone/iPad.

**Solutions:**
1. **Use Safari browser** - Chrome doesn't support PWA install on iOS
2. **Look for Share button** - Bottom of Safari screen
3. **Tap "Add to Home Screen"** - Not labeled as "Install"
4. **Check iOS version** - Must be iOS 11.3 or later
5. **Verify manifest** - Ensure all required fields present

### App Installs But Won't Open

**Problem:** App icon appears but clicking does nothing or shows error.

**Solutions:**
1. **Check start_url** in manifest - Must be valid and accessible
2. **Verify HTTPS** - All pages must load over HTTPS
3. **Clear app data**:
   - Android: Long-press > App Info > Storage > Clear Data
   - iOS: Delete app and reinstall
4. **Check for JavaScript errors** - Open DevTools console
5. **Update browser** - Ensure latest version

---

## Service Worker Issues

### Service Worker Not Registering

**Problem:** Service worker fails to register or activate.

**Solutions:**
1. **Verify HTTPS** - Service workers require secure connection
2. **Check file path** - Service worker file must be at correct location
3. **Review browser console** - Look for registration errors (F12)
4. **Clear browser cache** - Including service workers
5. **Check file syntax** - Ensure no JavaScript errors
6. **Verify scope** - Service worker scope matches app scope

**Debug in Chrome DevTools:**
1. Press **F12** to open DevTools
2. Go to **Application** tab
3. Click **Service Workers**
4. Check status and errors
5. Click **Unregister** to reset if needed

### Service Worker Not Updating

**Problem:** Changes don't appear after updating PWA Plus.

**Solutions:**
1. **Force update** - In DevTools > Application > Service Workers > Update
2. **Clear cache**:
   - DevTools > Application > Clear Storage > Clear site data
3. **Uninstall and reinstall app**
4. **Check cache strategy** - May be serving old cached content
5. **Increment version number** in service worker file

### Offline Mode Not Working

**Problem:** App doesn't work offline as expected.

**Solutions:**
1. **Verify caching is enabled** - Check PWA Plus configuration
2. **Test service worker** - DevTools > Application > Service Workers
3. **Check cache storage** - DevTools > Application > Cache Storage
4. **Review cached assets** - Ensure critical files are cached
5. **Test offline properly** - Use DevTools > Network > Offline

---

## Configuration Issues

### Changes Not Applying

**Problem:** Configuration updates don't take effect.

**Solutions:**
1. **Clear browser cache** - Hard refresh (Ctrl+Shift+R)
2. **Clear app cache** - Uninstall and reinstall PWA
3. **Update service worker** - Force update in DevTools
4. **Check manifest cache** - Browser may cache manifest.json
5. **Wait for propagation** - Can take a few minutes

### Custom Icons Not Showing

**Problem:** App icon doesn't display or shows wrong icon.

**Solutions:**
1. **Verify icon format** - Must be PNG
2. **Check dimensions** - Provide 192x192 and 512x512
3. **Ensure proper path** - Icons must be accessible via HTTPS
4. **Check file size** - Keep under 500KB each
5. **Use square images** - No rectangular icons
6. **Clear cache and reinstall**

### Colors Not Updating

**Problem:** Theme colors don't change.

**Solutions:**
1. **Use hex format** - e.g., #1E40AF (not rgb or named colors)
2. **Update manifest** - Colors defined in manifest.json
3. **Reinstall app** - Uninstall and install again
4. **Check browser support** - Some browsers ignore certain colors
5. **Verify CSS** - Check for conflicting styles

---

## Performance Issues

### Slow Loading

**Problem:** PWA loads slowly or lags.

**Solutions:**
1. **Enable caching** - Configure aggressive caching
2. **Optimize images** - Compress and resize
3. **Enable CDN** - Use content delivery network
4. **Check server resources** - CPU, RAM, bandwidth
5. **Review cache strategy** - Use "cache first" for static assets
6. **Minify assets** - Compress CSS/JS files

### High Data Usage

**Problem:** App uses too much bandwidth.

**Solutions:**
1. **Enable compression** - Gzip or Brotli
2. **Optimize images** - Use WebP format, compress
3. **Configure caching** - Cache more aggressively
4. **Reduce API calls** - Batch requests when possible
5. **Monitor network tab** - DevTools > Network

### App Crashes

**Problem:** PWA crashes or freezes.

**Solutions:**
1. **Check JavaScript errors** - DevTools Console
2. **Clear app data** - Reset app cache
3. **Update browser** - Use latest version
4. **Check memory usage** - Close other apps/tabs
5. **Reinstall app** - Fresh installation
6. **Review error logs** - Check WHMCS logs

---

## User-Specific Issues

### Cannot Log In to App

**Problem:** Login fails in PWA but works in browser.

**Solutions:**
1. **Clear app cache and cookies**
2. **Check credentials** - Verify username and password
3. **Disable browser extensions** - May interfere
4. **Try incognito/private mode** - Test without cache
5. **Reset password** - Use "Forgot Password"
6. **Check session handling** - Ensure cookies work in PWA

### Persistent Login Not Working

**Problem:** App doesn't remember login.

**Solutions:**
1. **Enable cookies** - Check browser settings
2. **Check storage permissions** - App may need permission
3. **Clear and re-login** - Fresh login session
4. **Verify secure cookies** - Must work over HTTPS
5. **Check WHMCS session settings**

### Push Notifications Not Working

**Problem:** Notifications don't appear (when feature is released).

**Solutions:**
1. **Grant permissions** - Check browser/system settings
2. **Enable in app settings** - App may have notification toggle
3. **Check browser support** - Not all browsers support notifications
4. **Verify HTTPS** - Required for notifications
5. **Test with browser notifications** - Ensure system allows

---

## Browser-Specific Issues

### Chrome/Edge Issues

**Problems:**
- Install button missing
- Service worker errors

**Solutions:**
1. Update to latest version
2. Clear browsing data (Ctrl+Shift+Del)
3. Disable conflicting extensions
4. Check chrome://flags for PWA settings
5. Reset browser settings if needed

### Safari Issues

**Problems:**
- Add to Home Screen not working
- Limited PWA features

**Solutions:**
1. Use Safari (not Chrome on iOS)
2. Check iOS version (11.3+)
3. Clear Safari cache
4. Ensure manifest has apple-touch-icon
5. Check for iOS-specific manifest properties

### Firefox Issues

**Problems:**
- Limited PWA support
- Install option missing

**Solutions:**
1. Note: Firefox has limited PWA support
2. Use Chrome or Edge for full features
3. Check about:config for PWA settings
4. Update to latest Firefox version

---

## Server & Hosting Issues

### HTTPS Certificate Problems

**Problem:** SSL errors or warnings.

**Solutions:**
1. **Install valid certificate** - Use Let's Encrypt (free)
2. **Renew expired certificate**
3. **Fix mixed content** - Ensure all resources use HTTPS
4. **Check certificate chain** - Ensure complete chain installed
5. **Force HTTPS redirect** - Update .htaccess

### File Permission Errors

**Problem:** Module files not accessible.

**Solutions:**
```bash
# Set correct permissions
find /path/to/whmcs/modules/addons/pwaplus -type d -exec chmod 755 {} \;
find /path/to/whmcs/modules/addons/pwaplus -type f -exec chmod 644 {} \;

# Fix ownership (if needed)
chown -R username:group /path/to/whmcs/modules/addons/pwaplus
```

### PHP Version Issues

**Problem:** Compatibility errors with PHP.

**Solutions:**
1. **Check PHP version**: `php -v`
2. **Update to PHP 7.4 or 8.x**
3. **Enable required extensions**
4. **Check error logs** for specific issues
5. **Contact hosting provider** for PHP updates

---

## Debugging Tools

### Chrome DevTools

Essential tabs for debugging:
- **Console**: JavaScript errors and logs
- **Application**: Service workers, cache, manifest
- **Network**: Request/response analysis
- **Lighthouse**: PWA audit and scores

### Useful Commands

```javascript
// Check service worker status
navigator.serviceWorker.getRegistrations().then(reg => console.log(reg));

// Clear all caches
caches.keys().then(keys => keys.forEach(key => caches.delete(key)));

// Check if app is installed
window.matchMedia('(display-mode: standalone)').matches
```

### Browser URLs

- Chrome: `chrome://inspect/#service-workers`
- Edge: `edge://serviceworker-internals/`
- Firefox: `about:debugging#/runtime/this-firefox`

---

## Getting More Help

If you're still experiencing issues:

1. **Check error logs** - WHMCS activity log
2. **Review browser console** - Look for specific errors
3. **Test in incognito mode** - Rule out cache issues
4. **Try different browser** - Isolate browser-specific problems
5. **Check [FAQ](/pwa-plus/faq)** - Common questions answered
6. **Contact [Support](/pwa-plus/support-maintenance/support)** - Get direct assistance

### When Contacting Support

Include this information:
- WHMCS version
- PHP version
- Server type (cPanel, Plesk, etc.)
- Browser and version
- Specific error messages
- Steps to reproduce issue
- Screenshots if applicable
