---
title: "Support"
description: "Support channels and assistance"
---

# Support & Help

Get assistance with PWA Plus installation, configuration, and troubleshooting through our priority ticket system.

---

## Documentation Resources

Before contacting support, check these helpful resources:

### Getting Started
- [Overview](/pwa-plus) – Introduction to PWA Plus
- [Features](/pwa-plus/features) – Complete feature list
- [Installation Guide](/pwa-plus/setup-guide/installation) – Step-by-step setup
- [FAQ](/pwa-plus/faq) – Frequently asked questions

### Configuration & Usage
- [Configuration Guide](/pwa-plus/setup-guide/configuration) – Customize your PWA
- [Admin Guide](/pwa-plus/user-guides/admin-guide) – For administrators
- [Client Guide](/pwa-plus/user-guides/client-guide) – For end-users
- [Deployment Guide](/pwa-plus/setup-guide/deployment) – Production setup

### Troubleshooting
- [Troubleshooting Guide](/pwa-plus/support-maintenance/troubleshooting) – Common issues and solutions
- [Changelog](/pwa-plus/support-maintenance/changelog) – Version history and updates

---

## Priority Support Ticket System

**We prioritize support tickets over email for faster resolution and better tracking.**

### Submit a Support Ticket

Visit our support ticket system and raise a ticket to the appropriate category:

**[Submit Support Ticket](https://sapphive.com/submitticket.php)**

---

## Support Categories

Choose the appropriate category when submitting your ticket:

### 1. Sales Inquiries
**sales@sapphive.com**

For pre-sales questions and product inquiries:
- Product demonstrations
- Licensing questions
- Pricing information
- Enterprise solutions
- Bulk licensing

### 2. Technical Support
**support@sapphive.com**

For technical assistance and troubleshooting:
- Installation help
- Configuration issues
- Bug reports
- Feature questions
- Performance optimization

### 3. Migration Assistance
**migrations@sapphive.com**

For migration and data transfer help:
- Migration from other platforms
- Data import/export
- Server migration support
- Version upgrades
- Legacy system transitions

### 4. Compliance & Security
**compliance@sapphive.com**

For compliance and security matters:
- GDPR compliance questions
- Security audits
- Privacy policy inquiries
- Data protection concerns
- Regulatory compliance

### 5. Abuse Reports
**abuse@sapphive.com**

For reporting misuse or violations:
- License violations
- Abuse reports
- Unauthorized usage
- Copyright concerns
- Terms of service violations

---

## How to Submit a Ticket

1. **Visit**: [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)
2. **Select Category**: Choose the appropriate department
3. **Provide Details**: Include all relevant information
4. **Submit**: You'll receive a ticket number for tracking

### What to Include in Your Ticket

For faster resolution, please provide:

**System Information:**
- WHMCS version
- PHP version
- Server type (cPanel, Plesk, etc.)
- PWA Plus version

**Issue Details:**
- Clear description of the issue
- Steps to reproduce
- Expected vs actual behavior
- When the issue started

**Supporting Materials:**
- Screenshots or screen recordings
- Error messages (full text)
- Browser console logs
- Server error logs (if applicable)

**Response Time:**
- Standard tickets: 24-48 hours
- Priority issues: 12-24 hours
- Critical issues: Within 6 hours

---

## Custom Development Requests

Need custom features, integrations, or white-label solutions?

**Submit a ticket to**: [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)

**Select Category**: Sales or Technical Support

**We offer:**
- Custom PWA themes
- Third-party integrations
- Feature development
- White-label solutions
- API integrations
- Bespoke functionality

---

## Community & Resources

### GitHub Repository

For open-source contributions and community support:

**[GitHub.com/sapphive](https://github.com/sapphive)**

- Report bugs and issues
- Request features
- View source code
- Contribute improvements
- Community discussions

### Social Media

Stay updated on releases and announcements:

- **Twitter**: [@sapphive](https://x.com/thesapphive)
- **LinkedIn**: [Sapphive](https://linkedin.com/company/sapphive)
- **Facebook**: [Sapphive](https://facebook.com/sapphive)

---

## Self-Service Tools

### Diagnostic Tools

**Check Service Worker Status:**
1. Open your site in Chrome
2. Press **F12** (Developer Tools)
3. Go to **Application** tab
4. Click **Service Workers**
5. Check status and errors

**Test PWA with Lighthouse:**
1. Open Developer Tools (F12)
2. Click **Lighthouse** tab
3. Select **Progressive Web App**
4. Click **Generate Report**

**Browser Console:**
- Press **F12** to open DevTools
- Check **Console** for errors
- Look for red error messages

---

## Common Support Scenarios

### Installation Help

**Need help installing?**
- Review [Installation Guide](/pwa-plus/setup-guide/installation)
- Check system requirements
- Verify HTTPS is enabled
- Ensure file permissions are correct

**Submit ticket to**: support@sapphive.com

### Configuration Assistance

**Need configuration help?**
- See [Configuration Guide](/pwa-plus/setup-guide/configuration)
- Review app settings checklist
- Test on multiple devices
- Check browser compatibility

**Submit ticket to**: support@sapphive.com

### Troubleshooting Issues

**Experiencing problems?**
- Consult [Troubleshooting Guide](/pwa-plus/support-maintenance/troubleshooting)
- Check browser console for errors
- Clear cache and retry
- Test in incognito mode

**Submit ticket to**: support@sapphive.com

---

## Update & Maintenance

### Software Updates

**How to update PWA Plus:**
1. Download latest version from your account
2. Backup current installation
3. Upload new files via FTP/cPanel
4. Clear WHMCS cache
5. Test functionality on all devices

Check [Changelog](/pwa-plus/support-maintenance/changelog) for version updates and release notes.


### Maintenance Notifications

Stay informed about updates and changes:
- Product update alerts
- Security advisories
- Feature releases
- Breaking changes

**Submit ticket to get added to notifications**: support@sapphive.com

---

## Enterprise Support

### Premium Support Plans

For high-traffic sites and enterprise customers:

**Benefits:**
- Priority support queue (6-hour response time)
- Dedicated account manager
- Direct phone support
- Custom SLA agreements
- Priority bug fixes
- Training and onboarding sessions
- Quarterly reviews

**Submit ticket for enterprise inquiries**: sales@sapphive.com via [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)

---

## Feedback & Feature Requests

### Share Your Ideas

Have an idea to improve PWA Plus?

**Submit feature requests:**
- **Support Ticket**: [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php) (support@sapphive.com)
- **GitHub Issues**: [Open an issue](https://github.com/sapphive)
- **Community Discussions**: Share in our community forums

We review all suggestions and prioritize based on:
- User demand
- Technical feasibility
- Product roadmap alignment
- Business value

### Product Reviews

Love PWA Plus? Help others discover it:
- Leave a review on WHMCS Marketplace
- Share on social media
- Write about your experience
- Recommend to colleagues

---

## Business Hours

### Support Availability

**Email Support**: Available 24/7
- All support emails monitored continuously
- Response within 24 hours for standard tickets
- Response within 4 hours for priority tickets
- Immediate attention for critical issues

**Office Hours**: Indian Business Hours
- Monday - Friday, 9:00 AM - 6:00 PM IST
- Account reviews
- Training sessions

**Weekends & Holidays**: Email support only
- Tickets submitted on weekends receive response on next business day
- Critical issues handled as needed
- Emergency support available for enterprise customers

---

## Legal & Compliance

### Important Policies

Review our legal documents:
- [Terms of Service](https://sapphive.com/legal/terms-of-services)
- [Privacy Policy](https://sapphive.com/legal/privacy-policy)
- [License Agreement](https://sapphive.com/license)

**Questions?** Submit ticket to: compliance@sapphive.com

### GDPR & Privacy Compliance

PWA Plus is designed with privacy in mind:
- No third-party tracking
- Data stored locally on user devices
- GDPR compliant
- No external dependencies
- Full data control

**Compliance inquiries**: compliance@sapphive.com via [submit ticket](https://sapphive.com/submitticket.php)

---

## Quick Links

### Helpful Resources

- [PWA Plus Home](/pwa-plus)
- [Installation Guide](/pwa-plus/setup-guide/installation)
- [Configuration Guide](/pwa-plus/setup-guide/configuration)
- [Troubleshooting](/pwa-plus/support-maintenance/troubleshooting)
- [FAQ](/pwa-plus/faq)
- [Changelog](/pwa-plus/support-maintenance/changelog)

### Submit Support Tickets

**Main Support Portal**: [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)

**Email Categories:**
- Sales: sales@sapphive.com
- Support: support@sapphive.com
- Migrations: migrations@sapphive.com
- Compliance: compliance@sapphive.com
- Abuse: abuse@sapphive.com

### Related Products

Explore other Sapphive solutions:
- PhonePe Payment Gateway for WHMCS
- Custom WHMCS modules
- Security and compliance tools
- Integration solutions

Visit: **[sapphive.com](https://sapphive.com)**

---

## Thank You

Thank you for choosing PWA Plus! We're committed to providing excellent support through our priority ticket system and continuously improving our products.

For any questions, assistance, or feedback, please submit a ticket at:

**[https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)**

We look forward to helping you succeed with PWA Plus for WHMCS!
