---
title: "Installation"
description: "Step-by-step installation guide"
---

# Installation Guide

Follow this step-by-step guide to install PWA Plus on your WHMCS system.

---

## Prerequisites

Before installing PWA Plus, ensure your system meets these requirements:

### System Requirements
- **WHMCS 8.0 or later**
- **PHP 7.4** or **PHP 8.x** (8.0, 8.1, 8.2, 8.3)
- **HTTPS enabled** (SSL certificate installed and active)
- Compatible hosting: cPanel, Plesk, DirectAdmin, or custom servers

### Important Notes
- **HTTPS is mandatory** for Progressive Web Apps to function properly
- Ensure you have admin access to your WHMCS installation
- Backup your WHMCS before installing any new modules

---

## Installation Steps

### Step 1: Download PWA Plus Module

1. Download the PWA Plus module package from your purchase source
2. Extract the downloaded ZIP file on your local computer
3. You should see a folder named `pwaplus`

### Step 2: Upload Module Files

Upload the module files to your WHMCS installation:

**Via FTP/SFTP:**
1. Connect to your server using FTP/SFTP client (FileZilla, WinSCP, etc.)
2. Navigate to your WHMCS installation directory
3. Go to `/modules/addons/`
4. Upload the entire `pwaplus` folder to this directory

**Via cPanel File Manager:**
1. Log into your cPanel
2. Open File Manager
3. Navigate to your WHMCS directory
4. Go to `/modules/addons/`
5. Upload and extract the module ZIP file here

**Final path should be:** `/path/to/whmcs/modules/addons/pwaplus/`

### Step 3: Activate the Module

1. Log into your **WHMCS Admin Area**
2. Navigate to **Setup > Addon Modules**
3. Find **PWA Plus** in the list of available modules
4. Click the **Activate** button
5. Configure access control if needed (grant access to admin roles)

### Step 4: Access Module Configuration

1. After activation, click **Configure** next to PWA Plus
2. You'll be taken to the PWA Plus settings page
3. Configure your app settings (detailed in [Configuration Guide](/pwa-plus/setup-guide/configuration))

---

## Post-Installation

### Verify Installation

1. Visit your WHMCS Client Area on a mobile device or desktop
2. You should see an **"Install App"** prompt or icon in the browser
3. Check browser console for any errors (F12 Developer Tools)

### Initial Configuration

Before going live, configure these essential settings:

- App name and description
- App icon/logo
- Theme colors
- Enable/disable for Client Area and Admin Area
- Test installation on multiple devices

### Next Steps

- Read the [Configuration Guide](/pwa-plus/setup-guide/configuration) to customize your PWA
- Review the [Deployment Guide](/pwa-plus/setup-guide/deployment) for production best practices
- Share the [Client Guide](/pwa-plus/user-guides/client-guide) with your users

---

## Troubleshooting Installation Issues

If you encounter issues during installation:

### Module Not Appearing in Addon Modules
- Verify the folder is uploaded to `/modules/addons/pwaplus/`
- Check file permissions (typically 755 for directories, 644 for files)
- Clear WHMCS template cache

### Cannot Activate Module
- Ensure PHP version meets requirements (7.4 or 8.x)
- Check WHMCS error logs for specific errors
- Verify you have admin permissions

### HTTPS Warnings
- PWA requires HTTPS to function
- Install or renew your SSL certificate
- Ensure your site is fully accessible via https://

For more troubleshooting help, visit the [Troubleshooting Guide](/pwa-plus/support-maintenance/troubleshooting) or [Contact Support](/pwa-plus/support-maintenance/support).
