--- 
title: "PWA Plus for WHMCS"
description: "A modern PWA bundle for WHMCS Admins and Clients — installable, offline-capable, and mobile-first."
---

# PWA Plus – Progressive Web App Module for WHMCS

PWA Plus is a powerful WHMCS addon module that transforms your WHMCS Client Area and Admin Area into fully installable, cross-platform Progressive Web Apps. With this module, your WHMCS instantly behaves like a native mobile and desktop application—**without publishing to app stores, without coding, and without any changes to the WHMCS core**.

Designed to enhance accessibility, speed, and user engagement, PWA Plus offers a seamless, app-like experience that works on **Android, iOS, Windows, macOS, and Linux**. Your users can install the app directly from the browser and enjoy a smooth, modern interface optimized for all devices.

---

## Why Choose PWA Plus?

### Enhanced User Engagement
Clients are more likely to return when your WHMCS behaves like a native app with instant access from their device's home screen.

### Improved Mobile Experience
Traditional WHMCS themes struggle on mobile—PWA Plus fixes that by providing smooth, responsive, mobile-optimized interfaces.

### Reduced Support Load
Offline support, fast caching, and persistent login help reduce customer frustrations and support tickets.

### Modernized Brand Image
Offering a dedicated app for clients and admins positions your business as modern, innovative, and user-friendly.

---

## How It Works

1. **Install** the PWA Plus module in your WHMCS system
2. **Configure** app settings (name, icon, theme, and preferences)
3. **Enable** PWA for Client Area, Admin Area, or both
4. **Users receive** an "Install App" prompt on supported devices
5. **The app installs** and behaves like a native mobile or desktop application
6. **Users enjoy** faster performance, clean UI, persistent login, and future features like notifications

---

## Compatibility

- Compatible with **WHMCS 8.0 and later**
- Works with **cPanel, Plesk, DirectAdmin**, and custom servers
- Supports **PHP 7.4** and **PHP 8.x**
- **Requires HTTPS** for PWA functionality

---

## Quick Links
- [Features](/pwa-plus/features) – Discover all key features
- [Installation](/pwa-plus/setup-guide/installation) – Step-by-step setup guide
- [Configuration](/pwa-plus/setup-guide/configuration) – Customize your PWA
- [Admin Guide](/pwa-plus/user-guides/admin-guide) – Manage your PWA module
- [Client Guide](/pwa-plus/user-guides/client-guide) – Help your users install the app
- [Deployment](/pwa-plus/setup-guide/deployment) – Production best practices
- [Troubleshooting](/pwa-plus/support-maintenance/troubleshooting) – Common issues & fixes
- [FAQ](/pwa-plus/faq) – Frequently asked questions
- [Changelog](/pwa-plus/support-maintenance/changelog) – Version history
- [Support](/pwa-plus/support-maintenance/support) – Get help
