---
title: "Troubleshooting"
description: "Troubleshooting guide for PhonePe Payment Gateway issues"
---

# Troubleshooting Guide

This guide helps resolve common issues with PhonePe Payment Gateway.

---

## Installation Issues

### Module Not Appearing After Upload

**Problem**: PhonePe gateway doesn't appear in payment gateways list.

**Causes**
- Files uploaded to wrong directory
- Incorrect file permissions
- WHMCS cache not cleared
- PHP errors in module files
- Database tables not created

**Solution**
1. Verify files uploaded to `/modules/gateways/phonepe/`
2. Check file permissions (755 for directories, 644 for files)
3. Clear WHMCS cache: Go to Settings → Utilities → System Cache
4. Check WHMCS error log for PHP errors
5. Restart web server: `sudo systemctl restart apache2` or `nginx`
6. Try logging out and back in

### Gateway Activates But Not Working

**Problem**: Gateway appears but payments don't process.

**Causes**
- Credentials not configured
- Callback URL not set
- PHP extensions not enabled
- Network connectivity issue

**Solution**
1. Go to Payment Gateways → PhonePe Settings
2. Verify Merchant ID entered
3. Verify API Key entered
4. Copy Callback URL and add to PhonePe webhook
5. Check PHP extensions: `php -m | grep -i curl`
6. Verify your domain is publicly accessible

---

## Configuration Issues

### Invalid Merchant ID Error

**Problem**: Error message "Invalid Merchant ID" during configuration.

**Causes**
- Merchant ID copied incorrectly
- Extra spaces in Merchant ID
- Using wrong environment (Dev ID in Production)
- Merchant ID not yet activated

**Solution**
1. Log in to PhonePe Business Account
2. Go to Settings → API Credentials
3. Copy Merchant ID carefully (no spaces)
4. Verify environment matches (Development/Production)
5. Contact PhonePe if ID not activated
6. Clear browser cache and retry

### API Key Not Accepted

**Problem**: "Invalid API Key" error message.

**Causes**
- API Key copied incorrectly
- Extra spaces or special characters
- Using development key in production
- Key expired or regenerated

**Solution**
1. Verify you copied full API Key (usually long string)
2. Check for leading/trailing spaces
3. Confirm using correct environment key
4. Log in to PhonePe to verify key is active
5. Regenerate key if needed
6. Test with small transaction

### Environment Settings Not Saving

**Problem**: Environment changes don't persist.

**Causes**
- Insufficient permissions
- Cache preventing save
- Database write issue
- Form validation error

**Solution**
1. Clear WHMCS system cache
2. Try private/incognito browser window
3. Check form for error messages
4. Verify database connectivity
5. Check file permissions on config files
6. Contact hosting support

---

## Payment Processing Issues

### Payments Not Processing

**Problem**: Customer clicks pay but nothing happens.

**Causes**
- JavaScript errors
- Callback URL not accessible
- Network connectivity issue
- Webhook not configured
- PhonePe service down

**Solution**
1. Check browser console for JavaScript errors (F12)
2. Test callback URL is publicly accessible
3. Ping PhonePe server: `ping api.phonepe.com`
4. Verify webhook is configured in PhonePe account
5. Check WHMCS error logs
6. Try different browser
7. Check PhonePe status page for service issues

### Transaction Times Out

**Problem**: Payment process takes too long or times out.

**Causes**
- Slow network connection
- Server processing delay
- PhonePe service slow
- Firewall blocking requests
- Timeout settings too short

**Solution**
1. Check internet connection speed
2. Review server resource usage (CPU, RAM, Disk)
3. Check PhonePe status for slowness
4. Verify firewall allows PhonePe IP addresses
5. Increase timeout settings in configuration
6. Test on different network
7. Contact PhonePe support

### Payment Successful But Invoice Not Updated

**Problem**: Customer paid but invoice still shows unpaid.

**Causes**
- Webhook callback not received
- WHMCS webhook handler error
- Transaction ID mismatch
- Database update failed
- Cron job not running

**Solution**
1. Check WHMCS webhook logs
2. Verify callback URL is correct
3. Test webhook from PhonePe dashboard
4. Check WHMCS error logs for SQL errors
5. Manually update invoice if transaction verified
6. Run WHMCS cron manually: Access `/cron.php`
7. Verify cron job scheduled properly

### Duplicate Payments Appearing

**Problem**: Customer charged twice for one payment.

**Causes**
- Customer clicked pay button twice
- Webhook triggered multiple times
- Callback processed multiple times
- Network retry causing duplicate

**Solution**
1. Check transaction details in PhonePe
2. Verify if both are actual charges
3. Process refund for duplicate
4. Contact customer
5. Advise customers not to refresh during payment
6. Review webhook logs for duplicates
7. Implement duplicate detection

---

## Webhook and Callback Issues

### Webhooks Not Being Received

**Problem**: Webhook callbacks not arriving in WHMCS.

**Causes**
- Callback URL incorrect
- Firewall blocking PhonePe IPs
- SSL certificate invalid
- Webhook not configured in PhonePe
- Network issue

**Solution**
1. Verify callback URL is correct and accessible
2. Test URL in browser directly
3. Check firewall allows incoming PhonePe requests
4. Verify SSL certificate is valid
5. Add PhonePe IPs to firewall whitelist
6. Test webhook delivery from PhonePe dashboard
7. Check server logs for webhook requests

### Webhook Errors in Logs

**Problem**: Error messages in webhook processing logs.

**Causes**
- Invalid transaction data
- PHP errors in webhook handler
- Database connection issue
- Encoding issues
- Insufficient permissions

**Solution**
1. Review exact error message in logs
2. Check PHP error log for details
3. Verify database connection
4. Test webhook with manual trigger
5. Check file permissions
6. Verify character encoding (UTF-8)
7. Contact technical support with error details

### Callback URL Returns Error

**Problem**: PhonePe reports "Callback URL Error" or "Invalid Response".

**Causes**
- Callback URL not publicly accessible
- Server returning error status
- Invalid SSL certificate
- Firewall rejecting connection
- Server configuration issue

**Solution**
1. Test callback URL from external source
2. Use online tools to verify URL accessibility
3. Check SSL certificate validity
4. Review web server logs for connection attempts
5. Verify firewall allows connections
6. Test with curl: `curl -v https://yourdomain.com/callback`
7. Contact hosting support

---

## Settlement and Refund Issues

### Payments Not Settled

**Problem**: Payments received but not settled to bank account.

**Causes**
- Settlement schedule not yet reached
- Settlement failed due to bank issue
- Merchant account restrictions
- PhonePe service issue
- Insufficient balance

**Solution**
1. Check PhonePe Business Account for settlement status
2. Verify settlement schedule and next settlement date
3. Check if settlement shows "Pending" or "Failed"
4. Verify bank account details are correct
5. Contact PhonePe support for failed settlements
6. Check for account restrictions or limits

### Refund Processing Fails

**Problem**: Refund initiated but fails to process.

**Causes**
- Original transaction too old
- Customer's payment method no longer valid
- Refund amount exceeds original
- PhonePe rate limiting
- Bank processing issue

**Solution**
1. Verify refund amount doesn't exceed original payment
2. Check original transaction date (must be recent enough)
3. Verify customer's payment method still active
4. Try refund after 24 hours if just tried
5. Contact PhonePe support with transaction ID
6. Process refund through alternative method if needed

### Partial Refunds Not Working

**Problem**: Cannot process partial refund for transaction.

**Causes**
- Configuration doesn't allow partial refunds
- Refund amount invalid
- Multiple refunds already attempted
- Transaction type doesn't support partial refund

**Solution**
1. Verify partial refund is enabled in settings
2. Check refund amount is valid (less than original)
3. Verify total refunds don't exceed original amount
4. Try full refund instead
5. Contact PhonePe support for technical issue

### Refund Appears Twice

**Problem**: Customer received refund twice for single refund request.

**Causes**
- Webhook processed twice
- Manual refund plus automatic refund
- PhonePe processing duplicate
- Network retry causing duplicate

**Solution**
1. Check transaction history for duplicate refund
2. Contact PhonePe to reverse duplicate refund
3. Document both refund transactions
4. Contact customer to return duplicate
5. Monitor for duplicate settlements
6. Review webhook logs for duplicates

---

## Security and Authorization Issues

### "Unauthorized" Error Messages

**Problem**: Getting unauthorized errors during payment.

**Causes**
- Merchant ID doesn't match
- API Key invalid
- Credentials expired
- Environment mismatch
- IP restrictions

**Solution**
1. Verify Merchant ID and API Key are correct
2. Check credentials in PhonePe Business Account
3. Regenerate credentials if needed
4. Verify using same environment (Dev/Production)
5. Check for IP whitelisting restrictions
6. Clear browser cookies and retry

### "Invalid Signature" Errors

**Problem**: Payment fails with invalid signature error.

**Causes**
- API Key changed
- Webhook endpoint not matching
- Encryption key mismatch
- Request body modified

**Solution**
1. Regenerate API credentials in PhonePe
2. Update credentials in WHMCS
3. Verify webhook endpoint is exact
4. Don't modify request data
5. Clear browser cache
6. Try different payment method

### SSL Certificate Issues

**Problem**: Browser warns about SSL certificate or "Not Secure" shows.

**Causes**
- SSL certificate not installed
- Certificate expired
- Certificate doesn't match domain
- Mixed content issue

**Solution**
1. Install valid SSL certificate for your domain
2. Verify certificate is not expired
3. Ensure domain matches certificate
4. Fix mixed content issues (http/https)
5. Use online SSL checker to verify
6. Contact hosting support for SSL help

---

## Database and Storage Issues

### Database Connection Errors

**Problem**: "Database Connection Error" messages appear.

**Causes**
- Database server down
- Incorrect credentials
- Connection timeout
- Firewall blocking database
- Disk space full

**Solution**
1. Check database server status
2. Verify database credentials in WHMCS config
3. Test database connection
4. Check firewall allows database connection
5. Verify adequate disk space
6. Contact hosting support

### Transaction Records Missing

**Problem**: Transactions processed but not in database.

**Causes**
- Database write failed
- Wrong database selected
- Storage full
- Transaction rolled back
- Webhook not received

**Solution**
1. Check available disk space
2. Run database integrity check
3. Verify correct database is configured
4. Review error logs for write errors
5. Check transaction exists in PhonePe
6. Restore from backup if needed

---

## Email and Notification Issues

### Confirmation Emails Not Sending

**Problem**: Customers not receiving payment confirmation emails.

**Causes**
- Email service not configured
- Email template missing
- SMTP server issue
- Email filtered to spam
- Email address invalid

**Solution**
1. Test email configuration in WHMCS
2. Verify email templates exist
3. Check SMTP server status
4. Review mail logs for errors
5. Check customer spam folder
6. Verify customer email address is correct

### Notification Emails Going to Spam

**Problem**: Emails delivered but going to spam folder.

**Causes**
- No SPF record
- No DKIM signature
- No DMARC policy
- Email content flagged
- Email domain reputation

**Solution**
1. Configure SPF record for domain
2. Set up DKIM signing
3. Configure DMARC policy
4. Review email content
5. Check domain reputation
6. Contact hosting for email configuration

---

## Performance Issues

### Slow Payment Processing

**Problem**: Payment takes unusually long to complete.

**Causes**
- Server resources low
- Database queries slow
- Network latency
- PhonePe service slow
- Too many plugins/extensions

**Solution**
1. Check server CPU/RAM/Disk usage
2. Optimize database queries
3. Enable caching
4. Test from different location
5. Check PhonePe status
6. Disable unnecessary plugins
7. Contact hosting for optimization

### High Error Rates

**Problem**: Many transactions failing or erroring.

**Causes**
- Server misconfiguration
- Webhook issues
- PhonePe service issues
- Database performance
- API rate limiting

**Solution**
1. Check error logs for patterns
2. Verify webhook configuration
3. Check PhonePe status page
4. Monitor server resources
5. Review transaction logs
6. Contact PhonePe support
7. Implement retry logic

---

## Getting Help

### Enable Debug Mode

Enable detailed logging:

1. Go to WHMCS Settings → Tools & Utilities
2. Set "Debug Log" to "On"
3. Set appropriate debug level
4. Reproduce the issue
5. Review logs at `/logs/` directory

### Contacting Support

When contacting support, provide:

- Error message (exact text)
- Steps to reproduce issue
- Transaction ID (if applicable)
- Server error logs
- WHMCS error logs
- Browser console errors
- Screenshots of issue

Email: support@sapphive.com

### Useful Logs to Review

Check these logs when troubleshooting:

- `/logs/error_log` - System errors
- `/logs/whmcs_activity.log` - WHMCS activity
- WHMCS webhook logs - Callback issues
- Web server error log - Server issues
- PHP error log - PHP errors
- Browser console (F12) - Frontend errors

---

## Common Error Messages

### "Gateway Not Configured"
- Verify credentials entered in settings
- Check credentials are saved

### "Invalid Invoice"
- Verify invoice exists
- Check invoice status
- Verify invoice is unpaid

### "Amount Mismatch"
- Verify amount matches invoice
- Check for currency conversion
- Verify no additional fees added

### "Service Unavailable"
- Check internet connection
- Verify PhonePe service is online
- Try again in few minutes

### "Timeout Error"
- Verify network connectivity
- Check PhonePe status
- Try again with different method

---

For further assistance, contact [Support](/phonepe/support-maintenance/support/).
