---
title: "Support"
description: "Support channels and assistance for PhonePe Payment Gateway"
---

# Support & Help

Get assistance with PhonePe Payment Gateway installation, configuration, and troubleshooting through our priority ticket system.

---

## Documentation Resources

Before contacting support, check these helpful resources:

### Getting Started
- [Overview](/phonepe) – Introduction to PhonePe Payment Gateway
- [Features](/phonepe/features) – Complete feature list
- [Installation Guide](/phonepe/setup-guide/installation) – Step-by-step setup
- [FAQ](/phonepe/faq) – Frequently asked questions

### Configuration & Usage
- [Configuration Guide](/phonepe/setup-guide/configuration) – Configure payment settings
- [Merchant Guide](/phonepe/guides/merchant-guide) – For merchants and administrators
- [Client Guide](/phonepe/guides/client-guide) – For end-users
- [Deployment Guide](/phonepe/setup-guide/deployment) – Production setup

### Troubleshooting
- [Troubleshooting Guide](/phonepe/support-maintenance/troubleshooting) – Common issues and solutions
- [Changelog](/phonepe/support-maintenance/changelog) – Version history and updates

---

## Priority Support Ticket System

**We prioritize support tickets over email for faster resolution and better tracking.**

### Submit a Support Ticket

Visit our support ticket system and raise a ticket to the appropriate category:

**[Submit Support Ticket](https://sapphive.com/submitticket.php)**

---

## Support Categories

Choose the appropriate category when submitting your ticket:

### 1. Sales Inquiries
**sales@sapphive.com**

For pre-sales questions and product inquiries:
- Product demonstrations
- Licensing questions
- Pricing information
- Enterprise solutions
- Bulk licensing
- Custom integrations

### 2. Technical Support
**support@sapphive.com**

For technical assistance and troubleshooting:
- Installation help
- Configuration issues
- Payment processing problems
- Webhook troubleshooting
- Bug reports
- Feature questions
- Performance optimization

### 3. Migration Assistance
**migrations@sapphive.com**

For migration and data transfer help:
- Migration from other payment gateways
- Transaction data import/export
- Server migration support
- Version upgrades
- Legacy system transitions

### 4. Compliance & Security
**compliance@sapphive.com**

For compliance and security matters:
- PCI DSS compliance questions
- Security audits
- Privacy policy inquiries
- Data protection concerns
- Regulatory compliance
- Payment security issues

### 5. Abuse Reports
**abuse@sapphive.com**

For reporting misuse or violations:
- License violations
- Fraudulent transaction reports
- Unauthorized usage
- Terms of service violations
- Security concerns

---

## How to Submit a Ticket

1. **Visit**: [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)
2. **Select Category**: Choose the appropriate department
3. **Provide Details**: Include all relevant information
4. **Submit**: You'll receive a ticket number for tracking

### What to Include in Your Ticket

For faster resolution, please provide:

**System Information:**
- WHMCS version
- PHP version
- Server type (cPanel, Plesk, etc.)
- PhonePe Payment Gateway version
- MySQL/MariaDB version

**Issue Details:**
- Clear description of the issue
- Steps to reproduce
- Expected vs actual behavior
- When the issue started
- Transaction IDs (if payment-related)

**Supporting Materials:**
- Screenshots or screen recordings
- Error messages (full text)
- Browser console logs
- Server error logs
- WHMCS system logs
- PhonePe transaction logs

**Response Time:**
- Standard tickets: 24-48 hours
- Priority issues: 12-24 hours
- Critical issues: Within 6 hours

---

## Custom Development Requests

Need custom features, integrations, or white-label solutions?

**Submit a ticket to**: [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)

**Select Category**: Sales or Technical Support

**We offer:**
- Custom payment flows
- Third-party integrations
- Feature development
- White-label solutions
- API customizations
- Bespoke functionality
- Payment gateway extensions


---

## Community & Resources

### GitHub Repository

For open-source contributions and community support:

**[GitHub.com/sapphive](https://github.com/sapphive)**

- Report bugs and issues
- Request features
- View source code
- Contribute improvements
- Community discussions

### Social Media

Stay updated on releases and announcements:

- **Twitter**: [@sapphive](https://x.com/thesapphive)
- **LinkedIn**: [Sapphive](https://linkedin.com/company/sapphive)
- **Facebook**: [Sapphive](https://facebook.com/sapphive)
- **Instagram**: [@sapphive.official](https://www.instagram.com/sapphive.official)

---

## Common Support Scenarios

### Installation Help

**Need help installing?**
- Review [Installation Guide](/phonepe/setup-guide/installation)
- Check system requirements
- Verify HTTPS is enabled
- Ensure file permissions are correct
- Confirm PhonePe merchant account is active

**Submit ticket to**: support@sapphive.com

### Configuration Assistance

**Need configuration help?**
- See [Configuration Guide](/phonepe/setup-guide/configuration)
- Review PhonePe credentials
- Test webhook URLs
- Check callback configuration
- Verify currency settings

**Submit ticket to**: support@sapphive.com

### Payment Processing Issues

**Experiencing payment problems?**
- Consult [Troubleshooting Guide](/phonepe/support-maintenance/troubleshooting)
- Check PhonePe dashboard
- Verify merchant credentials
- Test in sandbox mode
- Review transaction logs

**Submit ticket to**: support@sapphive.com

### Refund & Settlement Issues

**Need refund assistance?**
- See [Merchant Guide](/phonepe/guides/merchant-guide)
- Check settlement status
- Verify refund policies
- Review transaction details
- Contact PhonePe support if needed

**Submit ticket to**: support@sapphive.com

---

## Maintenance Schedule

### Regular Maintenance Tasks

**Weekly**
- Review transaction logs
- Monitor success rates
- Check webhook delivery
- Verify settlement reports
- Test payment flows

**Monthly**
- Review settlement reconciliation
- Analyze transaction trends
- Check security logs
- Update documentation
- Performance review

**Quarterly**
- Full system audit
- Security assessment
- Compliance verification
- Database optimization
- Capacity planning

### Software Updates

**How to update PhonePe Payment Gateway:**
1. Download latest version from your account
2. Backup current installation
3. Review changelog for breaking changes
4. Upload new files via FTP/cPanel
5. Clear WHMCS cache
6. Test payment processing

Check [Changelog](/phonepe/support-maintenance/changelog) for version updates and release notes.

### Maintenance Notifications

Stay informed about updates and changes:
- Product update alerts
- Security advisories
- PhonePe API changes
- Feature releases
- Breaking changes

**Submit ticket to get added to notifications**: support@sapphive.com

---

## Enterprise Support

### Dedicated Support Options

**Enterprise customers receive:**
- Dedicated account manager
- Priority ticket handling
- Custom SLA agreements
- Quarterly business reviews
- Direct escalation path
- Advanced technical consultation

**Submit ticket to**: sales@sapphive.com (to inquire about enterprise plans)

### Custom Development & Integration

**Need custom features?**
- Custom payment workflows
- Advanced integrations
- White-label solutions
- API customizations
- Specialized reporting
- Third-party integrations

**Submit ticket to**: support@sapphive.com

### Training & Onboarding

**We offer:**
- Live training sessions
- Custom onboarding programs
- Team training workshops
- Documentation library
- Best practices consultation

**Submit ticket to**: support@sapphive.com

---

## Feedback & Feature Requests

### Share Your Feedback

Your input helps us improve! Submit feedback about:

- Feature requests
- User experience improvements
- Documentation suggestions
- Bug reports
- Performance issues
- Integration ideas

**Submit ticket to**: support@sapphive.com

### Feature Roadmap

View our development roadmap:
- Upcoming features
- Planned improvements
- Enhancement timeline
- Community-requested features

**Submit ticket** to request roadmap access or suggest features.

### Beta Testing

Interested in testing new features early?

**Beta Program Benefits:**
- Early access to new features
- Influence product direction
- Direct feedback channel
- Priority support during testing
- Recognition in release notes

**Submit ticket to**: support@sapphive.com (subject: "Beta Testing Interest")

---

## Business Hours

### Support Availability

**Email Support**: Available 24/7
- All support emails monitored continuously
- Response within 24 hours for standard tickets
- Response within 4 hours for priority tickets
- Immediate attention for critical issues

**Office Hours**: Indian Business Hours
- Monday - Friday, 9:00 AM - 6:00 PM IST
- Account reviews
- Training sessions

**Weekends & Holidays**: Email support only
- Tickets submitted on weekends receive response on next business day
- Critical issues handled as needed
- Emergency support available for enterprise customers

---

## Legal & Compliance

### Data Privacy

We take your privacy seriously:
- GDPR compliant operations
- Secure data handling
- Privacy policy compliance
- Data retention policies
- Right to erasure support

**Submit ticket to**: compliance@sapphive.com

### PCI DSS Compliance

**PhonePe Payment Gateway supports PCI DSS compliance:**
- No card data stored locally
- Secure payment processing through PhonePe
- Tokenization supported
- Compliance documentation available
- Regular security audits

**Submit ticket to**: compliance@sapphive.com

### Terms of Service

Review our terms:
- [Terms of Service](https://sapphive.com/legal/terms-of-services)
- [Privacy Policy](https://sapphive.com/legal/privacy-policy)

### Abuse Reports

Report abuse or security issues:

**Submit ticket to**: abuse@sapphive.com

Include:
- Nature of the issue
- Affected URLs or accounts
- Evidence or screenshots
- Your contact information
- Urgency level

---

## Quick Links

### Essential Resources

**Installation & Setup**
- [Installation Guide](/phonepe/setup-guide/installation)
- [Configuration Guide](/phonepe/setup-guide/configuration)
- [Merchant Setup](/phonepe/guides/merchant-guide)

**Payment Operations**
- [Processing Payments](/phonepe/guides/payment-processing)
- [Refunds & Chargebacks](/phonepe/guides/merchant-guide)
- [Settlement Reports](/phonepe/guides/merchant-guide)

**Support & Maintenance**
- [Troubleshooting](/phonepe/support-maintenance/troubleshooting)
- [Changelog](/phonepe/support-maintenance/changelog)
- [FAQ](/phonepe/support-maintenance/faq)

**Developer Resources**
- [GitHub Repository](https://github.com/sapphive)
- [API Documentation](/phonepe/guides/merchant-guide)

### Contact Methods

**Sales Inquiries**: sales@sapphive.com  
**Technical Support**: support@sapphive.com  
**Migrations**: migrations@sapphive.com  
**Compliance**: compliance@sapphive.com  
**Abuse Reports**: abuse@sapphive.com  

**Submit Support Ticket**: [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)

---

## Frequently Asked Questions (FAQ)

### General Support Questions

**Q: What are your support hours?**  
A: Email support is available 24/7 with response times of 24 hours for standard tickets and 4 hours for priority tickets. Office hours are Indian Business Hours (Monday-Friday, 9:00 AM - 6:00 PM IST).

**Q: How do I submit a support ticket?**
A: Visit [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php) and provide detailed information about your issue, including system details, error messages, and steps to reproduce the problem.

**Q: How long does it take to receive a response?**  
A: Most tickets receive a response within 24 hours. Priority tickets are responded to within 4 hours. Critical issues affecting live payment processing receive immediate attention.

**Q: Is support included with my license?**  
A: Yes, email support is included with all licenses. Premium and enterprise support packages with additional features are available for purchase.

**Q: Can I get help outside business hours?**  
A: Yes, our email support operates 24/7. Tickets submitted outside business hours will be reviewed and responded to according to their priority level.

### Technical Questions

**Q: Why are payments failing on my site?**  
A: Common causes include incorrect merchant credentials, webhook configuration issues, SSL/HTTPS problems, or PhonePe account issues. Check the [Troubleshooting Guide](/phonepe/support-maintenance/troubleshooting) for detailed diagnostics.

**Q: How do I update to the latest version?**  
A: Download the latest version from your Sapphive account, backup your current installation, upload new files via FTP/cPanel, and clear the WHMCS cache. See the [Installation Guide](/phonepe/setup-guide/installation) for detailed steps.

**Q: Where can I find my transaction logs?**  
A: Transaction logs are available in WHMCS under System Logs → Gateway Log. You can also view transaction details in your PhonePe merchant dashboard at [https://business.phonepe.com](https://business.phonepe.com).

**Q: How do I process refunds?**  
A: Refunds are processed through your PhonePe merchant dashboard. Log in to your PhonePe account, locate the transaction, and initiate the refund. See the [Merchant Guide](/phonepe/guides/merchant-guide) for detailed instructions.

**Q: Why aren't webhooks working?**  
A: Verify that your webhook URL is publicly accessible over HTTPS, check that your server isn't blocking PhonePe's IP addresses, and ensure webhook verification is correctly implemented. See [Configuration Guide](/phonepe/setup-guide/configuration).

**Q: How do I test payments in sandbox mode?**  
A: Enable sandbox mode in the PhonePe gateway configuration, use PhonePe's test merchant credentials, and use PhonePe's test payment methods. Detailed instructions are in the [Configuration Guide](/phonepe/setup-guide/configuration).

### Account & Billing Questions

**Q: How do I upgrade my license?**  
A: Contact our sales team at sales@sapphive.com to discuss upgrade options, pricing, and features for your specific needs.

**Q: What happens when my license expires?**  
A: You'll receive renewal reminders before expiration. After expiration, there's a 30-day grace period during which the service continues with warnings. After the grace period, the service is suspended until renewal.

**Q: Can I transfer my license to another domain?**  
A: Yes, license transfers are supported. Submit a ticket to support@sapphive.com with your current and new domain information for assistance.

**Q: Do you offer refunds?**  
A: Refund policies vary by license type. Contact sales@sapphive.com for specific questions about refunds.

### Integration Questions

**Q: Is the gateway compatible with my WHMCS version?**  
A: PhonePe Payment Gateway supports WHMCS 7.0 and above. Check the [Installation Guide](/phonepe/setup-guide/installation) for specific version requirements and compatibility information.

**Q: Can I customize the payment flow?**  
A: Yes, customization options are available. Contact support@sapphive.com for custom development options or enterprise features.

**Q: Does it support multi-currency?**  
A: PhonePe Payment Gateway primarily supports INR (Indian Rupee). For multi-currency requirements, contact sales@sapphive.com to discuss options.

**Q: Can I use this with other modules?**  
A: Yes, the gateway is designed to work alongside other WHMCS modules. If you experience conflicts, submit a ticket to support@sapphive.com for assistance.

### Security & Compliance Questions

**Q: Is the gateway PCI DSS compliant?**  
A: Yes, by processing payments through PhonePe, no sensitive card data is stored on your server, helping maintain PCI DSS compliance. PhonePe handles all sensitive payment information.

**Q: How is customer data protected?**  
A: Data is protected through encrypted connections (HTTPS/SSL), secure API communication with PhonePe, and compliance with data privacy regulations. See our [Privacy Policy](https://sapphive.com/legal/privacy-policy) for details.

**Q: What security measures should I implement?**  
A: Ensure HTTPS is enabled on your site, keep WHMCS and the gateway updated, use strong passwords, implement two-factor authentication, and regularly review access logs.

**Q: How do I report a security vulnerability?**  
A: Report security issues immediately to abuse@sapphive.com. Include detailed information about the vulnerability, steps to reproduce, and potential impact.

### Getting More Help

**Q: Can I speak with someone directly?**  
A: For direct assistance, submit a detailed ticket to support@sapphive.com during Indian Business Hours (Monday-Friday, 9:00 AM - 6:00 PM IST) for the fastest response.

**Q: Do you offer migration assistance?**  
A: Yes! If you're migrating from another payment gateway, our team can assist. Contact migrations@sapphive.com for migration support and guidance.

**Q: How do I provide feedback or request features?**  
A: We welcome feedback! Submit feature requests or suggestions via ticket to support@sapphive.com. Your input helps shape our product roadmap.

---

## Need More Help?

If you couldn't find the answer to your question, our support team is here to assist you.

**Submit a Support Ticket**: [https://sapphive.com/submitticket.php](https://sapphive.com/submitticket.php)

**Email Support**:
- General Support: support@sapphive.com
- Sales: sales@sapphive.com
- Migrations: migrations@sapphive.com
- Compliance: compliance@sapphive.com
- Abuse: abuse@sapphive.com

**Follow Us**:
- Twitter: [@sapphive](https://x.com/thesapphive)
- GitHub: [github.com/sapphive](https://github.com/sapphive)
- LinkedIn: [Sapphive](https://linkedin.com/company/sapphive)

---

**Last Updated**: January 2025  
**Version**: 2.5.0
