---
title: "Installation"
description: "Step-by-step installation guide for PhonePe Payment Gateway"
---

# Installation Guide

Follow these steps to install and set up PhonePe Payment Gateway for WHMCS.

---

## System Requirements

Before installation, ensure your system meets the following requirements:

- WHMCS version 8.0 or higher
- PHP 7.4 or higher
- cURL extension enabled
- OpenSSL extension enabled
- Sufficient server permissions

---

## Step 1: Download the Module

1. Log in to your Sapphire dashboard
2. Navigate to Downloads section
3. Locate "PhonePe Payment Gateway Module"
4. Click Download to get the latest version
5. Extract the downloaded file

---

## Step 2: Prepare Installation Files

1. Open the extracted folder
2. Locate the `modules/gateways/phonepe/` directory
3. Verify all required files are present:
   - `phonepe.php`
   - `lib/` directory with library files
   - `config.php`
   - `templates/` directory

---

## Step 3: Upload to WHMCS

1. Connect to your server via FTP or use your hosting control panel file manager
2. Navigate to your WHMCS installation directory
3. Go to `modules/gateways/` folder
4. Upload the PhonePe gateway folder into `modules/gateways/`
5. Ensure file permissions are set to 755 for directories and 644 for files

---

## Step 4: Activate the Gateway

1. Log in to WHMCS Admin Panel
2. Navigate to Settings → Payment Gateways
3. Click "All Payment Gateways"
4. Locate "PhonePe Payment Gateway" in the list
5. Click "Activate" button
6. The gateway will now appear in your list of active gateways

---

## Step 5: Configure API Credentials

1. From the Payment Gateways page, click the Settings icon next to PhonePe
2. You'll see the configuration form
3. Enter your PhonePe Merchant ID:
   - Log in to your PhonePe Business Account
   - Navigate to API Settings
   - Copy your Merchant ID
   - Paste into the WHMCS configuration field

4. Enter your API Key:
   - From PhonePe Business Account
   - Copy your API Key
   - Paste into the WHMCS configuration field

5. Select your environment:
   - Development (for testing)
   - Production (for live transactions)

6. Click "Save Changes"

---

## Step 6: Configure Callback URL

PhonePe requires a callback URL to send payment notifications:

1. In WHMCS PhonePe settings, copy the Callback URL shown
2. Log in to your PhonePe Business Account
3. Navigate to Webhook Settings
4. Add a new webhook endpoint
5. Paste the callback URL from WHMCS
6. Select "Transaction Status" event type
7. Save the webhook configuration

---

## Step 7: Set As Default Gateway (Optional)

1. Go to Settings → Payment Gateways
2. Under "Default Gateway", select PhonePe from dropdown
3. Click Save
4. This will make PhonePe the default payment option for clients

---

## Step 8: Verify Installation

1. Go to your client portal
2. Attempt to view an unpaid invoice
3. Click "Pay Now" button
4. You should see PhonePe as a payment option
5. Click on PhonePe to verify the checkout form displays correctly

---

## Troubleshooting Installation

### Files Not Uploading

- Check server file permissions
- Ensure FTP connection is stable
- Verify you're uploading to correct directory

### Gateway Not Appearing

- Clear WHMCS cache
- Verify file permissions (755 for directories, 644 for files)
- Check WHMCS error logs

### Callback URL Issues

- Verify your domain SSL certificate is valid
- Check firewall rules allow PhonePe IP addresses
- Test callback URL is publicly accessible

---

## Next Steps

Once installation is complete:

1. Complete [Configuration](/phonepe/setup-guide/configuration/) to customize settings
2. Review [Merchant Guide](/phonepe/guides/merchant-guide/) for best practices
3. Set up [Support & Maintenance](/phonepe/support-maintenance/support/) for ongoing operations

For assistance, contact [Support](/phonepe/support-maintenance/support/) or refer to our [Troubleshooting Guide](/phonepe/support-maintenance/troubleshooting/).
