---
title: "Deployment"
description: "Production deployment guide for PhonePe Payment Gateway"
---

# Deployment Guide

This guide covers deploying PhonePe Payment Gateway to production environment.

---

## Pre-Deployment Checklist

Before deploying to production, ensure:

### System Requirements
- WHMCS version 8.0+ installed
- PHP 7.4+ configured
- cURL and OpenSSL extensions enabled
- SSL certificate valid and installed
- Adequate server disk space available
- Database backups current

### Module Requirements
- PhonePe module version latest
- All dependencies installed
- No conflicts with other modules
- Folder permissions correct (755/644)
- Database tables created

### Configuration Requirements
- Merchant ID configured
- API Key secure and saved
- Callback URL verified and accessible
- Webhook configuration complete
- Currency settings correct
- Environment set to Production

### Testing Completion
- All features tested in development
- Payment flow verified
- Refund process tested
- Webhook callbacks confirmed
- Error scenarios tested
- Security validation complete

---

## Development to Production Migration

### Step 1: Environment Switch

Switch from development to production:

1. Log in to WHMCS Admin Panel
2. Go to Settings → Payment Gateways
3. Click PhonePe Settings
4. Change Environment: Development → Production
5. Verify all credentials are correct
6. Click Save Changes

### Step 2: Verify Production Credentials

Confirm your production credentials:

1. Log in to PhonePe Business Account
2. Switch to Production mode
3. Copy Production Merchant ID
4. Copy Production API Key
5. Verify both match WHMCS configuration
6. Test with small transaction

### Step 3: Verify Callback Configuration

Ensure webhooks are production-ready:

1. Go to PhonePe Business Account
2. Navigate to Webhook Settings
3. Verify Callback URL points to production domain
4. Test webhook delivery from PhonePe
5. Confirm callbacks are being received
6. Check WHMCS logs for webhook entries

### Step 4: Production Database

Prepare your production database:

1. Back up current database
2. Clear any test transactions
3. Archive old transaction records if needed
4. Verify database integrity
5. Check available storage space
6. Enable automatic backups

### Step 5: Server Configuration

Optimize server settings:

**Security**
- Enable SSL/TLS (HTTPS only)
- Configure firewall rules
- Allow PhonePe IP addresses
- Enable WAF rules
- Regular security updates

**Performance**
- Enable caching
- Optimize database queries
- Configure email delivery
- Set up monitoring
- Enable error logging

**Backup & Recovery**
- Automatic daily backups
- Backup verification scheduled
- Disaster recovery plan
- Test restore process
- Off-site backup storage

---

## Production Deployment

### Step 1: Final Backup

Create complete production backup:

```bash
# Backup database
mysqldump -u username -p whmcs_db > whmcs_backup_$(date +%Y%m%d_%H%M%S).sql

# Backup files
tar -czf whmcs_files_backup_$(date +%Y%m%d_%H%M%S).tar.gz /path/to/whmcs
```

### Step 2: Verify All Systems

Perform final system check:

1. WHMCS status page accessible
2. Admin panel responsive
3. Client portal loading correctly
4. Email system functioning
5. Database performing well
6. Logs writing properly

### Step 3: Enable Production Mode

Activate production operations:

1. Set PhonePe to Production environment
2. Enable production credentials
3. Activate payment processing
4. Enable customer notifications
5. Enable admin alerts
6. Start monitoring systems

### Step 4: Test First Transaction

Process test transaction in production:

1. Create test invoice for small amount
2. Process payment through PhonePe
3. Verify payment received and recorded
4. Check invoice status updated
5. Verify confirmations sent
6. Review transaction logs

### Step 5: Monitor Closely

Close monitoring for first week:

**Daily Tasks**
- Review all transactions
- Check error logs
- Monitor performance
- Verify backups completed
- Test webhook callbacks

**Weekly Review**
- Transaction summary
- Settlement verification
- Customer support tickets
- System performance metrics
- Security logs

---

## Security Deployment

### SSL/TLS Configuration

Ensure secure communications:

1. Install valid SSL certificate
2. Configure HTTPS everywhere
3. Set HTTP to HTTPS redirect
4. Configure security headers
5. Test SSL configuration
6. Verify certificate validity

### API Security

Protect your PhonePe credentials:

1. Store credentials securely
2. Never hardcode sensitive data
3. Use environment variables
4. Restrict file permissions
5. Regular credential rotation
6. Monitor API usage

### Database Security

Secure your transaction data:

1. Use strong database passwords
2. Restrict database access
3. Enable database encryption
4. Regular security patches
5. Monitor access logs
6. Implement query logging

### Access Control

Limit administrative access:

1. Strong admin passwords
2. Two-factor authentication
3. IP whitelisting for admin
4. Role-based access control
5. Activity logging
6. Regular access reviews

---

## Monitoring and Maintenance

### System Monitoring

Monitor production health:

**Metrics to Track**
- Uptime percentage
- Response time
- Transaction success rate
- Error rates
- Database performance
- Backup completion

**Monitoring Tools**
- WHMCS built-in status
- Server monitoring service
- Application monitoring
- Real User Monitoring (RUM)
- Synthetic monitoring

### Performance Optimization

Maintain optimal performance:

1. Monitor transaction volume
2. Optimize database queries
3. Implement caching
4. Compress images
5. Minimize CSS/JavaScript
6. Content delivery network (CDN)

### Backup Verification

Ensure backups are reliable:

1. Daily automated backups
2. Weekly backup testing
3. Monthly full restore test
4. Off-site backup storage
5. Backup retention policy
6. Disaster recovery drills

---

## Troubleshooting Production Issues

### Payment Processing Issues

If payments fail in production:

**Diagnosis**
1. Check transaction logs
2. Verify PhonePe status page
3. Review error messages
4. Check webhook callbacks
5. Verify network connectivity
6. Review server logs

**Resolution**
1. Verify credentials are correct
2. Check callback URL accessibility
3. Review firewall rules
4. Test with different payment method
5. Contact PhonePe support
6. Document issue for review

### High Transaction Failure Rate

If many transactions failing:

1. Check PhonePe service status
2. Verify webhook configuration
3. Review error logs for patterns
4. Check for rate limiting
5. Verify network connectivity
6. Contact technical support

### Performance Degradation

If system slowing down:

1. Check server resources (CPU, RAM)
2. Monitor database performance
3. Review query logs
4. Check for connection issues
5. Verify backup processes
6. Enable caching if not active

### Webhook Callback Issues

If transactions not being recorded:

1. Verify callback URL accessible
2. Test webhook delivery from PhonePe
3. Check firewall rules
4. Review webhook logs
5. Verify WHMCS webhook handler
6. Test with manual transaction

---

## Post-Deployment Validation

### Functionality Testing

Verify all features working:

- Payments processing correctly
- Invoices updating automatically
- Emails sending properly
- Refunds working
- Webhook callbacks received
- Transactions logged accurately

### User Experience Testing

Ensure smooth customer experience:

- Payment form displays correctly
- Checkout process fast
- Confirmation received
- Receipt accessible
- Invoice updated immediately
- No errors or warnings

### Security Validation

Confirm security measures:

- HTTPS enforced
- Secure headers present
- Data encrypted
- No sensitive data exposed
- Access controls working
- Logs protected

### Performance Validation

Confirm performance standards:

- Page load time < 3 seconds
- Transaction processing < 5 seconds
- 99.9% uptime achieved
- No bottlenecks present
- Caching working effectively
- Database queries optimized

---

## Rollback Procedure

If issues occur after deployment:

### Emergency Rollback

1. Stop payment processing
2. Restore from backup
3. Notify customers
4. Document issue
5. Review what went wrong
6. Plan corrective action
7. Redeploy with fixes

### Step-by-Step Rollback

1. Stop WHMCS payment processing
2. Disable PhonePe gateway temporarily
3. Restore database from backup
4. Restore configuration files
5. Restart web server
6. Verify system functionality
7. Re-enable after verification

---

## Post-Deployment Support

### Ongoing Maintenance

Regular maintenance tasks:

**Weekly**
- Review transaction summaries
- Check system health
- Test backups
- Monitor performance

**Monthly**
- Security audit
- Performance analysis
- Customer feedback review
- Update logs summary

**Quarterly**
- Full system review
- Security assessment
- Capacity planning
- Documentation update

### Support Resources

Access help resources:

- Technical documentation
- Troubleshooting guides
- Support team contact
- Community forums
- Knowledge base

---

## Deployment Checklist

Final deployment checklist:

- [ ] All backups completed
- [ ] Credentials verified (Production)
- [ ] SSL certificate valid
- [ ] Webhook URL updated to production
- [ ] Environment switched to Production
- [ ] Test transaction successful
- [ ] Monitoring enabled
- [ ] Team notified
- [ ] Documentation updated
- [ ] First-week monitoring scheduled

---

For deployment support, contact [Support](/phonepe/support-maintenance/support/) or see [Troubleshooting](/phonepe/support-maintenance/troubleshooting/).
