---
title: "Configuration"
description: "Complete configuration guide for PhonePe Payment Gateway"
---

# Configuration Guide

This guide covers all configuration options for PhonePe Payment Gateway in WHMCS.

---

## Basic Configuration

### Merchant ID

Your unique merchant identifier provided by PhonePe.

- **Where to find**: PhonePe Business Account → API Settings → Merchant ID
- **Format**: Alphanumeric string
- **Required**: Yes
- **Impact**: All transactions are associated with this ID

### API Key

Secret key for authenticating requests to PhonePe servers.

- **Where to find**: PhonePe Business Account → API Settings → API Key
- **Format**: Alphanumeric string
- **Required**: Yes
- **Security**: Treat as confidential, never share publicly
- **Rotation**: Change regularly for security best practices

### Environment

Select the operational environment for your gateway.

**Development**
- Used for testing payments
- Does not process real transactions
- Free to use with test credentials
- Recommended for initial setup and testing

**Production**
- Processes real customer payments
- Requires live PhonePe credentials
- Subject to transaction fees
- Enable only after thorough testing

---

## Payment Configuration

### Accepted Payment Methods

Configure which payment methods customers can use through PhonePe:

- UPI (Unified Payments Interface)
- Linked Bank Accounts
- Debit Card Payments
- Credit Card Payments
- Net Banking
- Digital Wallets

**Configuration**: All payment methods are enabled through PhonePe's interface. Customers select their preferred method during checkout.

### Transaction Amount Limits

Set minimum and maximum transaction amounts:

**Minimum Amount**
- Default: Based on PhonePe guidelines
- Minimum Allowed: 1 rupee
- Recommended: 10 rupees

**Maximum Amount**
- Default: Based on PhonePe guidelines
- Maximum Allowed: Depends on your merchant limits
- Recommended: 100,000 rupees per transaction

### Currency Support

PhonePe supports multiple currencies in India:

- Indian Rupee (INR) - Primary
- Configure currency conversion if needed
- Real-time exchange rates for multi-currency

---

## Advanced Settings

### Webhook Configuration

Enable real-time payment status updates:

**Webhook URL**: Automatically provided by WHMCS
- Copy this URL from WHMCS settings
- Add to PhonePe merchant account webhook settings
- Verify URL is publicly accessible
- Test webhook delivery in PhonePe dashboard

**Webhook Events to Enable**:
- PAYMENT_SUCCESS
- PAYMENT_FAILED
- PAYMENT_PENDING
- REFUND_SUCCESS
- REFUND_FAILED

### Callback Timeout

Time allowed for payment processing:

- **Default**: 30 seconds
- **Recommended**: 30-60 seconds
- **Maximum**: 120 seconds
- Higher values reduce failed transactions

### Customizable Gateway Name

Personalize the payment gateway display name:

- Customize how PhonePe appears in checkout
- Change the gateway name for your customers
- Enhance branding and user experience
- Useful for organizing multiple WHMCS instances

### Transaction Prefix

Customize transaction reference prefix:

- Helps identify transactions in your system
- Default: "PHONEPE_"
- Example: "PHONEPE_INV_12345"
- Useful for transaction organization

---

## Security Settings

### SSL Verification

Ensure secure communication:

- **Enabled**: Recommended (default)
- **Disabled**: Only for testing with invalid certificates
- **Setting**: Keep enabled in production

### API Timeout

Duration for API requests:

- **Default**: 20 seconds
- **Minimum**: 5 seconds
- **Maximum**: 60 seconds
- Increase if experiencing timeouts with PhonePe

### Encryption

Payment data encryption options:

- **Enabled**: All sensitive data encrypted
- **Algorithm**: AES-256 (industry standard)
- **Keys**: Automatically managed by WHMCS

---

## Notification Settings

### Email Notifications

Configure customer payment notifications:

**Payment Success Email**
- Automatically sent to customer
- Include transaction reference and amount
- Enable/Disable in settings

**Payment Failed Email**
- Notifies customer of failed payment
- Includes retry option
- Help contact information

### Admin Notifications

Receive alerts for payment events:

**Transaction Alerts**
- Enabled: Admin notified of all transactions
- Large transactions only: Alert for amounts over threshold
- Disabled: No admin alerts

**Threshold Amount** (if using transaction alerts)
- Default: 10,000 rupees
- Customizable based on preference

---

## Invoice Configuration

### Auto Invoice Generation

Control automatic invoice processing:

- **On Payment Success**: Invoice automatically marked paid
- **Manual Verification**: Admin reviews before marking paid
- **Recommended**: On Payment Success for efficiency

### Invoice Status Updates

Configure how invoices are updated:

- Update immediately on payment
- Update after webhook confirmation
- Manual update option

### Overpayment Handling

When customer pays more than invoice amount:

- Create credit on account
- Refund difference automatically
- Manual review by admin

### Underpayment Handling

When customer pays less than invoice amount:

- Reject payment (customer must pay full amount)
- Create partial payment (invoice remains open)
- Admin review required

---

## Refund Configuration

### Custom Processing Fee

Add configurable processing fees to transactions:

**Fee Configuration**
- Add custom processing fee percentage
- Offset payment gateway charges
- Per-transaction customization
- Gateway-specific fee settings

**Fee Application**
- Applied at checkout
- Shown to customer before payment
- Collected with transaction amount
- Appears on invoice

### Refund Policy

Set your refund processing policy:

**Refund from WHMCS Dashboard**
- Initiate refunds directly from WHMCS admin panel
- No manual PhonePe Dashboard intervention required
- Automatic processing and tracking
- Full refund history in WHMCS

**Refund Processing Time**
- Standard: 3-5 business days
- Expedited: 24 hours (premium plan)
- Custom: Define your policy

**Refund Method**
- Back to original payment method
- Store credit
- Combination of both

### Automatic Refunds

Enable automatic refund processing:

- Invoice deletion within X days
- Service cancellation refunds
- Manual approval required: Yes/No

### Refund Limits

Set boundaries for automatic refunds:

- Minimum refund amount: 10 rupees
- Maximum refund amount: Unlimited
- Refund limit per invoice: Based on original amount

---

## Testing Configuration

### Test Mode

Simulate payments during setup and testing:

- **Activation**: Use PhonePe test/sandbox credentials
- **Benefits**: Test full payment flow without processing real transactions
- **Duration**: Keep enabled until thoroughly tested
- **Checklist**: Complete all tests before production
- **Use Case**: Ideal for initial setup and feature testing

### Live Test Mode

Test live payments without affecting invoice records:

- **Activation**: Use production credentials but mark as test
- **Benefits**: Test real payment flow without recording test transactions on invoices
- **Invoice Impact**: Test transactions do not appear on customer invoices
- **Data Integrity**: Maintains clean and accurate invoice data
- **Use Case**: Final testing before enabling Live Mode

### Live Mode

Process real transactions in production:

- **Activation**: Production credentials with Live Mode enabled
- **Benefits**: Full integration with PhonePe for actual customer payments
- **Invoice Integration**: All transactions recorded on invoices
- **Settlement**: Real funds transferred to merchant account
- **Use Case**: Active payment processing for customers

### Logging

Enable detailed transaction logging:

- Log all payment attempts
- Log webhook callbacks
- Log configuration changes
- Log error details

**Log Location**: WHMCS/logs/

### Debug Mode

Enable for troubleshooting:

- Additional logging detail
- Performance metrics
- Integration testing information
- Disable in production for security

---

## Verification

After configuration:

1. Test with small transaction amount
2. Verify payment appears in PhonePe dashboard
3. Check webhook callbacks arrive
4. Confirm invoice status updates
5. Test refund process
6. Review transaction logs

---

## Common Configuration Issues

**Payments Not Processing**
- Verify Merchant ID and API Key
- Check webhook configuration
- Verify callback URL is accessible

**Webhook Callbacks Not Arriving**
- Confirm webhook URL is public
- Check firewall settings
- Verify SSL certificate validity

**Currency Mismatch**
- Ensure WHMCS currency matches PhonePe merchant account
- Configure conversion if needed

---

For support with configuration, visit [Support](/phonepe/support-maintenance/support/) or [Troubleshooting](/phonepe/support-maintenance/troubleshooting/).
