---
title: "Merchant Guide"
description: "Complete guide for merchants using PhonePe Payment Gateway"
---

# Merchant Guide

This comprehensive guide covers all aspects of managing PhonePe payments as a merchant.

---

## Getting Started as a Merchant

### Account Setup

To use PhonePe Payment Gateway with your WHMCS installation:

1. Ensure PhonePe module is installed and activated
2. Configure your Merchant ID and API Key
3. Set your preferred payment methods
4. Test with development environment first

### Your Dashboard

Access your payment dashboard:

1. Log in to WHMCS Admin Panel
2. Navigate to Orders → Payments
3. View all PhonePe transactions
4. Filter and search transactions
5. Access transaction details and history

---

## Payment Processing

### Invoice Payment Flow

When customers pay an invoice through PhonePe:

1. Customer clicks "Pay Now" on invoice
2. Redirected to PhonePe payment page
3. Customer selects payment method
4. Payment is processed by PhonePe
5. Confirmation is sent to your WHMCS system
6. Invoice automatically marked as paid
7. Customer receives payment confirmation email

### Payment Methods Available

Your customers can pay using:

**Digital Payment Methods via PhonePe**
- UPI (Unified Payments Interface)
- Linked Bank Accounts
- Net Banking
- Debit Cards
- Credit Cards
- Digital Wallets

**Payment Processing**
- Real-time processing
- Instant confirmation
- Secure transaction handling
- Support for all PhonePe payment modes

### Transaction Status

Monitor payment status through WHMCS:

- **Pending**: Payment initiated, awaiting confirmation
- **Success**: Payment completed successfully
- **Failed**: Payment declined or unsuccessful
- **Refunded**: Payment has been refunded

---

## Transaction Management

### View All Transactions

Access comprehensive transaction history:

1. Go to Orders → Payments in WHMCS
2. Filter by PhonePe gateway
3. View transaction list with:
   - Transaction ID
   - Amount
   - Status
   - Date/Time
   - Customer name
   - Related invoice

### Transaction Details

Access detailed information for any transaction:

1. Click on transaction in list
2. View complete transaction information:
   - Full transaction reference
   - Customer details
   - Invoice associated
   - Payment method used
   - Exact amount and fees
   - Timestamp
   - Payment status

### Search and Filter

Find specific transactions easily:

**Search Options**
- By Transaction ID
- By Customer Name
- By Invoice Number
- By Amount
- By Date Range

**Filter Options**
- Payment Status (Success/Failed/Pending)
- Payment Method
- Date Range
- Amount Range
- Specific customer

### Export Transactions

Generate transaction reports:

1. Select desired transaction range
2. Click "Export" or "Generate Report"
3. Choose export format (CSV, PDF, Excel)
4. Use for accounting and reconciliation

---

## Settlement and Payouts

### Settlement Process

How your payments are transferred:

1. Customer makes payment through PhonePe
2. Payment is processed and confirmed
3. Settlement is prepared based on your schedule
4. Funds transferred to your bank account
5. Settlement report generated

### Settlement Schedule

Standard settlement timelines:

- **Standard Settlement**: T+2 (within 2-3 business days)
- **Instant Settlement**: Available with premium plan
- **Frequency**: Daily or weekly as configured

### Settlement Reporting

View detailed settlement information:

1. Go to Payment Gateways → PhonePe
2. Click "Settlement Reports" tab
3. View settlement history:
   - Settlement date
   - Transactions included
   - Total amount settled
   - Fees deducted
   - Net settlement amount
   - Bank transfer details

### Reconciliation

Reconcile transactions with settlements:

1. Download transaction export
2. Download settlement report
3. Match transactions to settlements
4. Verify amounts and fees
5. Record in accounting system

---

## Refund Management

### Processing Refunds

How to refund customer payments:

1. Go to Orders → Payments
2. Find the transaction to refund
3. Click "Refund" button
4. Enter refund amount (full or partial)
5. Add refund reason/note
6. Click "Process Refund"
7. Confirmation is sent to customer

### Refund Status

Monitor refund progress:

- **Pending**: Refund initiated, processing
- **Processing**: Refund being transferred
- **Completed**: Refund successfully transferred
- **Failed**: Refund failed, review reason

### Partial Refunds

Issue partial refunds for invoices:

1. Select transaction
2. Choose partial refund option
3. Enter refund amount (less than original)
4. Specify reason
5. Remaining balance noted on invoice
6. Customer may need to pay difference

### Full Refunds

Issue refunds for entire transaction:

1. Select transaction
2. Choose full refund option
3. Enter reason
4. Confirm refund amount (equals transaction amount)
5. Process refund
6. Invoice marked as unpaid or credited

### Refund Processing Time

Standard refund timelines:

- **Initiation**: Immediate (same day)
- **Processing**: 1-3 business days
- **Receipt**: 3-5 business days
- **Instant Refund**: Available with premium plan

---

## Customer Communication

### Payment Confirmation

Automatic communications sent to customers:

**Payment Success**
- Sent immediately after payment
- Includes transaction reference
- Invoice marked as paid
- Receipt attached

**Payment Failed**
- Sent if payment declined
- Reason for failure included
- Option to retry payment
- Support contact information

### Custom Notifications

Send additional communications:

1. Go to Tickets or Emails
2. Compose message to customer
3. Include transaction details if needed
4. Reference transaction ID
5. Provide support information

---

## Troubleshooting Common Issues

### Payment Not Reflecting

If payment received but not showing:

1. Check transaction exists in PhonePe dashboard
2. Verify webhook is configured correctly
3. Check WHMCS logs for errors
4. Wait up to 60 seconds for webhook delivery
5. Manually mark invoice as paid if needed

### Refund Failed

If refund fails to process:

1. Verify original transaction was successful
2. Check refund amount doesn't exceed original
3. Confirm customer's payment method is still active
4. Check PhonePe account for limitations
5. Contact PhonePe support if persistent

### Duplicate Charges

Prevent duplicate charges:

1. Advise customers not to refresh during payment
2. Only click payment button once
3. Wait for confirmation page
4. Check transaction ID before retrying

### Customer Disputes

Handle customer payment disputes:

1. Review transaction details
2. Verify payment was received by PhonePe
3. Check customer's payment method confirmation
4. Process refund if appropriate
5. Document communication
6. Escalate to PhonePe if needed

---

## Best Practices

### Session Management Best Practices

Ensure uninterrupted payment processing:

- No logout issues during payment processing
- Built-in session management prevents interruptions
- Customers remain logged in through checkout
- Secure session handling protects user data

### Payment Security

Maintain secure payment operations:

- Keep PhonePe credentials confidential
- Use strong passwords
- Enable two-factor authentication
- Regularly update WHMCS
- Monitor for suspicious activity

### Transaction Monitoring

Regular transaction oversight:

- Review daily transaction summaries
- Check for unusual patterns
- Monitor failed payment rates
- Track average transaction amounts
- Analyze refund patterns

### Customer Experience

Optimize for better results:

- Keep checkout process simple
- Display PhonePe clearly as option
- Provide payment confirmation quickly
- Respond to payment issues promptly
- Maintain transparent fee information

### Accounting

Maintain accurate records:

- Reconcile settlements regularly
- Track fees and expenses
- Document refunds with reasons
- Generate monthly reports
- Maintain audit trail

---

## FAQ

**How long does settlement take?**
Standard settlement is 2-3 business days. Instant settlement available with premium plan.

**Can customers pay partially?**
Yes, configure underpayment handling in settings to allow partial payments.

**What if a customer claims they didn't receive their payment receipt?**
Resend receipt from transaction details or email customer manually.

**How do I handle duplicate payments?**
Mark one as refund and process refund to customer. Contact support if needed.

**Can I set different rates for different payment methods?**
PhonePe fees are uniform. Configure WHMCS to apply additional fees if needed.

---

For further assistance, visit [Support](/phonepe/support-maintenance/support/) or [Troubleshooting](/phonepe/support-maintenance/troubleshooting/).
