---
title: "Client Guide"
description: "Guide for end-users on paying with PhonePe"
---

# Client Guide

This guide helps your customers understand how to pay invoices using PhonePe Payment Gateway.

---

## What is PhonePe?

PhonePe is a secure, fast, and convenient digital payment platform that allows customers to pay invoices online using multiple payment methods including:

- UPI (Unified Payments Interface)
- Net Banking
- Debit and Credit Cards
- Digital Wallets
- Other payment methods

---

## Getting Started

### Creating a PhonePe Account

To use PhonePe for payments, customers need a PhonePe account:

1. Download PhonePe app from App Store or Google Play
2. Open the app and create new account
3. Enter mobile number
4. Verify with OTP
5. Complete account setup
6. Link payment method to account

Note: PhonePe account is optional for web payments through WHMCS.

### Linking Payment Methods

Customers can link various payment methods:

**UPI**
- Link your bank account via UPI ID
- Fast and secure
- No card details needed

**Debit/Credit Cards**
- Add card details
- CVV required
- Stored securely by PhonePe

**Net Banking**
- Direct bank login
- Real-time verification
- Most secure method

**Wallets**
- Link prepaid wallet
- Instant transactions
- Pre-loaded balance

---

## Making a Payment

### Step-by-Step Payment Process

Follow these steps to pay an invoice:

**Step 1: Access Your Invoice**
1. Log in to your customer account in WHMCS
2. Navigate to "Invoices" or "My Services"
3. Find the unpaid invoice
4. Click "Pay Now" button

**Step 2: Select Payment Method**
1. You'll see available payment options
2. Select "PhonePe Payment Gateway"
3. Click "Continue" or "Pay Now"

**Step 3: Enter Payment Details**
1. You'll be redirected to PhonePe payment page
2. Invoice amount will be pre-filled
3. Review the amount carefully
4. Verify merchant details

**Step 4: Choose Payment Method**
1. Select your preferred payment method:
   - UPI (Unified Payments Interface)
   - Linked Bank Account
   - Net Banking
   - Debit Card
   - Credit Card
   - Digital Wallet

**Step 5: Complete Transaction**
1. Follow PhonePe's payment process
2. Enter OTP if required
3. Confirm payment amount
4. Submit payment

**Step 6: Payment Confirmation**
1. You'll receive payment confirmation
2. Redirected back to WHMCS
3. Receipt is generated
4. Confirmation email sent to your account

---

## Payment Methods

### UPI Payments

Fastest and easiest method:

**Advantages**
- Instant processing
- Low fees
- No card needed
- Direct bank connection
- Real-time confirmation

**How to Pay with UPI**
1. Select UPI from payment methods
2. Enter your UPI ID (yourname@bank)
3. Authenticate with your bank
4. Confirm amount
5. Payment processed immediately

### Linked Bank Account Payments

Direct payment from your bank account:

**Advantages**
- Direct fund transfer from your bank
- Secure bank authentication
- No intermediary required for processing
- Real-time payment confirmation

**How to Pay with Linked Bank Account**
1. Select Linked Bank Account option from PhonePe
2. Choose your linked bank account
3. Authenticate with your bank
4. Confirm the payment amount
5. Payment processed immediately

### Net Banking

Most secure payment method:

**Advantages**
- Direct bank authentication
- Highest security
- Government backing
- Real-time verification

**How to Pay with Net Banking**
1. Select Net Banking option
2. Choose your bank from list
3. Log in to your bank account
4. Authenticate transaction
5. Confirm payment

### Card Payments

Convenient for card users:

**Advantages**
- Quick payment
- Rewards and cashback possible
- Statement tracking
- Works worldwide

**How to Pay with Card**
1. Select Card Payment
2. Enter card details (if not saved)
3. Enter card expiry date
4. Enter CVV number
5. Confirm payment

### Wallet Payments

Pre-loaded balance option:

**Advantages**
- Instant processing
- Pre-loaded funds
- No authentication needed
- Fastest checkout

**How to Pay with Wallet**
1. Select Wallet option
2. Confirm wallet balance
3. Authorize payment
4. Payment completed immediately

---

## Payment Issues

### Payment Failed

If your payment fails:

**Possible Reasons**
- Insufficient funds
- Network connectivity issue
- Payment method deactivated
- Incorrect OTP
- Bank server issues

**What to Do**
1. Wait few minutes
2. Check your bank account (payment may be debited)
3. Try alternative payment method
4. Contact your bank
5. Contact merchant support

### Payment Timeout

If payment times out:

1. Wait for confirmation page to load
2. Check your bank for debit
3. Contact support with transaction details
4. Do NOT retry immediately

### Duplicate Payment

If charged twice:

1. Note both transaction IDs
2. Contact support immediately
3. Provide transaction details
4. Refund will be processed
5. Allow 3-5 business days for refund

### Network Issues

If disconnected during payment:

1. Do not refresh page
2. Wait for confirmation
3. Check bank account
4. Wait before retrying
5. Contact support if needed

---

## Payment Confirmation

### Receipt

You receive a receipt after payment:

**Contains**
- Transaction reference number
- Amount paid
- Payment date and time
- Invoice number
- Merchant details
- Payment method used

**Where to Find**
- Email inbox (confirmation email)
- WHMCS account under invoices
- PhonePe transaction history

### Invoice Update

Your invoice is automatically updated:

- Invoice status changed to "Paid"
- Payment date recorded
- Services activated (if applicable)
- No further action needed

### Confirmation Email

You'll receive email confirmation:

**Email Contains**
- Payment confirmation
- Transaction reference
- Invoice paid status
- Service activation details
- Support contact information

**Check Spam Folder**
- Confirmation emails sometimes go to spam
- Check if not received
- Add support email to contacts

---

## Tracking Payments

### View Payment History

Track all your payments:

1. Log in to WHMCS account
2. Go to Invoices section
3. Click on paid invoice
4. View payment details:
   - Transaction reference
   - Payment date
   - Amount paid
   - Payment method

### PhonePe Transaction History

View payments in PhonePe:

1. Open PhonePe app or website
2. Go to Transactions
3. Find payment to merchant
4. View transaction details
5. Download receipt if needed

### Bank Statement

Payments appear in bank statement:

- Within 3-5 business days
- Show transaction reference
- Show merchant name
- Show amount deducted
- Transaction type as "Payment"

---

## Refunds

### If You Need a Refund

Request a refund process:

1. Contact merchant support
2. Explain reason for refund
3. Provide transaction reference
4. Merchant reviews request
5. Refund is processed

### Refund Processing

Once refund approved:

**Refund Timeline**
- Initiation: Immediately
- Processing: 1-3 business days
- Receipt: 3-5 business days

**Refund Method**
- Money returned to original payment method
- May appear as credit
- Check bank/payment app 5-7 days later

### Checking Refund Status

Track your refund:

1. Go to PhonePe transaction
2. Check transaction status
3. Contact support if not completed
4. Provide transaction reference

---

## Security and Safety

### Protecting Your Information

Keep your payments secure:

**Do's**
- Use strong passwords
- Enable two-factor authentication
- Use secure internet connection
- Verify merchant details
- Keep receipts

**Don'ts**
- Share payment details
- Use public WiFi for payments
- Save sensitive information in browsers
- Click suspicious links
- Share transaction IDs with strangers

### Data Protection

Your payment data is protected:

- Bank-grade encryption
- PCI-DSS compliance
- Secure server connection (HTTPS)
- No sensitive data stored
- Regular security audits

### Dispute Resolution

If you dispute a charge:

1. Contact merchant support first
2. Provide transaction details
3. Merchant will review
4. Escalate to PhonePe if needed
5. PhonePe will investigate

---

## FAQ

**Is PhonePe payment safe?**
Yes, PhonePe uses bank-grade encryption and is PCI-DSS compliant. Your payment details are secure.

**How long does payment take?**
Most payments process instantly. Some methods may take 1-2 minutes.

**What if I enter wrong amount?**
Don't proceed. Close payment and start over with correct invoice.

**Can I save payment method?**
Yes, PhonePe allows saving payment methods for future transactions.

**Do I need a PhonePe account?**
No, web payments work without PhonePe account, though having one provides additional features.

**Can I cancel payment?**
No, once submitted, payment processes immediately. Contact support for refund.

**What if I don't receive confirmation?**
Check email spam folder. Contact support if still not received.

**Are there any hidden fees?**
No, all fees are displayed before payment. PhonePe handles processing fees.

---

## Getting Help

### Support Channels

Get help with your payments:

**Contact Support**
- Email: support@sapphive.com
- Support Portal: https://sapphive.com/supporttickets.php
- Twitter/X: https://x.com/thesapphive
- Facebook: https://facebook.com/sapphive
- Instagram: https://www.instagram.com/sapphive.official

**Response Time**
- Urgent: 2-4 hours
- Standard: 24 hours
- Non-urgent: 2-3 business days

### Common Issues

Check our [Troubleshooting Guide](/phonepe/support-maintenance/troubleshooting/) for:
- Payment failures
- Refund issues
- Transaction problems
- Account issues
- General questions

---

Thank you for using PhonePe Payment Gateway. We appreciate your business!

For additional help, visit our [Support Page](/phonepe/support-maintenance/support/).
