---
title: Sapphive Documentation
description: Complete documentation for all Sapphive WHMCS modules and extensions.
template: splash
hero:
  tagline: Comprehensive Documentation for Sapphive WHMCS Solutions
  image:
    file: ../../assets/houston.webp
    alt: Sapphive WHMCS Solutions
  actions:
    - text: Browse All Products
      link: /products/
      icon: right-arrow
    - text: Quick Start Guide
      link: /getting-started/
      icon: open-book
---



## Welcome to Sapphive Documentation

Sapphive provides powerful, enterprise-grade WHMCS modules and extensions designed to enhance your hosting business. Our comprehensive solutions cover payments, progressive web apps, and more.

## Featured Products

<CardGrid stagger>
	<Card title="PWA Plus for WHMCS" icon="rocket">
		Transform your WHMCS into a modern Progressive Web App for clients and admins with offline support and automatic updates.
	</Card>
	<Card title="PhonePe Payment Gateway" icon="star">
		Accept PhonePe payments directly in WHMCS with seamless integration, instant settlements, and comprehensive reporting.
	</Card>
	<Card title="More Solutions Coming" icon="add-document">
		Sapphive is continuously developing new modules to expand WHMCS capabilities and improve business operations.
	</Card>
</CardGrid>

## Quick Navigation

### PWA Plus for WHMCS
Installable Progressive Web App for WHMCS Client and Admin Areas with offline support, automatic caching, and cross-platform compatibility.

- [PWA Plus Overview](/pwa-plus/) - Learn about PWA Plus features and benefits
- [Installation Guide](/pwa-plus/setup-guide/installation/) - Get PWA Plus up and running
- [Configuration](/pwa-plus/setup-guide/configuration/) - Customize to your brand
- [Client Guide](/pwa-plus/user-guides/client-guide/) - Help your users install and use

### PhonePe Payment Gateway
Accept PhonePe payments in WHMCS with advanced payment processing and merchant management tools.

- [PhonePe Overview](/phonepe/) - Introduction and key features
- [Installation Guide](/phonepe/setup-guide/installation/) - Setup instructions
- [Configuration](/phonepe/setup-guide/configuration/) - Configure payment settings
- [Merchant Guide](/phonepe/guides/merchant-guide/) - Manage payments

---

## Why Choose Sapphive?

- **Enterprise Quality** - Professional, thoroughly tested modules
- **Easy Integration** - Seamless WHMCS integration without core modifications
- **Continuous Support** - Dedicated support team ready to help
- **Regular Updates** - New features and security updates regularly
- **Community Driven** - Built with feedback from hosting businesses
- **Scalable Solutions** - Grow your business with Sapphive

## Getting Started

1. Choose your product from the list above
2. Follow the installation and configuration guides
3. Contact support if you need assistance

## Need Help?

- Visit the [Support Center](/support/) for FAQs and troubleshooting
- Check [Contact Us](/contact/) for direct support options
- Browse our [Knowledge Base](/kb/) for common solutions

---

**Sapphive** - Empowering WHMCS Hosting Businesses
