---
title: "Getting Started with Sapphive"
description: "Quick start guide for Sapphive WHMCS modules"
---

# Overview

Welcome to Sapphive! This guide will help you get started with our WHMCS modules.

---

## Choose Your Product

### 1. PWA Plus for WHMCS

**Best for:** Hosting businesses wanting to provide a modern app experience

Sapphive PWA Plus transforms your WHMCS Client and Admin areas into installable Progressive Web Apps.

- Works on all major platforms (Android, iOS, Windows, macOS, Linux)
- Offline support and automatic caching
- No third-party dependencies
- Zero maintenance required

**Get Started:** [PWA Plus Installation Guide](/pwa-plus/setup-guide/installation/)

---

### 2. PhonePe Payment Gateway

**Best for:** Hosting businesses accepting PhonePe payments

Accept PhonePe payments directly in WHMCS with comprehensive payment processing and reporting.

- Seamless WHMCS integration
- Instant settlement processing
- Comprehensive transaction reporting
- Secure payment handling

**Get Started:** [PhonePe Installation Guide](/phonepe/setup-guide/installation/)

---

## Installation Process

All Sapphive modules follow a similar installation process:

### Step 1: Download
Download your chosen module from Sapphive

### Step 2: Upload
Upload the module files to your WHMCS installation

### Step 3: Activate
Activate the module in WHMCS Admin Area

### Step 4: Configure
Configure the module settings to match your requirements

### Step 5: Deploy
Deploy to production and start using

---

## Common Requirements

All Sapphive modules require:

- WHMCS 8.0 or later
- PHP 7.4 or PHP 8.x
- HTTPS enabled (SSL certificate)
- Compatible server (cPanel, Plesk, DirectAdmin, or custom)

---

## Need Help?

- Browse [Products](/products/) to see what's available
- Check specific product documentation for detailed guides
- Visit [Support Center](/pwa-plus/support-maintenance/support/) for FAQ and troubleshooting

---

## What's Next?

1. Choose the product you're interested in
2. Read the product overview and features
3. Follow the installation and configuration guides
4. Deploy to your production environment
5. Contact support if you need assistance

Happy with Sapphive? Share your experience and help other hosting businesses discover our solutions!
